/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
  i-net software 1998-2013

*/
namespace Inet.Viewer
{
    /// <summary>
    /// Constants for the viewer command tokens. Mainly used by the Loader class
    /// and the classes that inherit from it.  
    /// </summary>
    public class ViewerTokenConstants
    {
        /// <summary>
        /// Attributes: ServerVersion (string), ProtocolVersion (string)
        /// </summary>
        internal const int TokenVersion = 0;

        /// <summary>
        /// Attributes: Code (4-byte number), message (string), format (string), serverVersion (string), serverJVM (string), serverOS (string), serverCache (number), stacktrace (string)
        /// </summary>
        internal const int TokenErrorMessage = 1;

        /// <summary>
        /// Attributes: Rangestart (number), rangeend (number)
        /// Sub elements: Page
        /// </summary>
        internal const int TokenPages = 4;

        /// <summary>
        /// Attribues: ReportFlags (number), AllowedFormats (String[]), Title (String), FileName (String)
        /// </summary>
        internal const int TokenReportInfo = 5;

        /// <summary>
        /// Attribues: PageNumber (number), PageWidth (number), PageHeight (number), WestMargin (number), EastMargin (number), 
        ///            NorthMargin (number), SouthMargin (number), PageLayoutAlignment (number), RenderTimeStamp (8-byte number)
        /// </summary>
        public const int TokenPageInfo = 6;

        /// <summary>
        /// Sub elements: Font
        /// </summary>
        public const int TokenFonts = 10;

        /// <summary>
        /// Sub elements: Adornments
        /// </summary>
        internal const int TokenAdornments = 12;

        /// <summary>
        /// Attributes: name (string), style (number C), size (number), embeddedFontID (number), embeddedFontVersion (number)
        /// </summary>
        internal const int TokenFont = 13;

        /// <summary>
        /// Attributes: leftStyle (number C), rightStyle (number C), topStyle (number C), bottomStyle (number C), lineWidth (number), ellipseWidth (number), ellipseHeight (number), shadow (number)
        /// </summary>
        internal const int TokenAdornment = 15;

        /// <summary>
        /// Attributes: fontID (number)
        /// </summary>
        public const int TokenSetCurrentFont = 16;

        /// <summary>
        /// Attributes: color (4-byte number)
        /// </summary>
        internal const int TokenSetCurrentDrawColor = 17;

        /// <summary>
        /// Attributes: color (4-byte number)
        /// </summary>
        internal const int TokenSetCurrentFillColor = 18;

        /// <summary>
        /// Attributes: adornmentID (number)
        /// </summary>
        internal const int TokenSetCurrentAdornment = 19;

        /// <summary>
        /// Attributes: paint (Gradientpaint)
        /// </summary>
        internal const int TokenSetCurrentDrawPaint = 20;

        /// <summary>
        /// Attributes: paint (Gradientpaint)
        /// </summary>
        internal const int TokenSetCurrentFillPaint = 21;

        /// <summary>
        /// Attributes: paint (Texturepaint)
        /// </summary>
        internal const int TokenSetCurrentTextureDrawPaint = 22;

        /// <summary>
        /// Attributes: paint (Texturepaint)
        /// </summary>
        internal const int TokenSetCurrentTextureFillPaint = 23;

        /// <summary>
        /// Resets the clipping.
        /// </summary>
        internal const int TokenResetClip = 28;

        /// <summary>
        /// Attributes: x (number), y (number), width (number), height (number), type (number), hyperlink (string), tooltip (string)
        /// </summary>
        internal const int TokenHyperlink = 29;

        /// <summary>
        /// Attributes:  x (number), y (number), width (number), height (number), tooltip (string)
        /// Sub elements: DrawString, DrawLine, DrawRect, FillRect, DrawFillRect, DrawImage, DrawPolyline, DrawPolygon, FillPolygon, DrawFillPolygon, DrawOval, FillOval, DrawArc, FillArc
        /// </summary>
        internal const int TokenClip = 30;

        /// <summary>
        /// Attributes: x (number), y (number), alignment (number C), rotation (number), expectedWidth (number) maxWidth (number), text (string)
        /// </summary>
        public const int TokenDrawString = 31;

        /// <summary>
        /// Attributes: x1 (number), y1 (number), x2 (number), y2 (number), adornmentID (number)
        /// </summary>
        internal const int TokenDrawLine = 32;

        /// <summary>
        /// Attributes: x (number), y (number), width (number), height (number)
        /// </summary>
        internal const int TokenDrawRect = 33;

        /// <summary>
        /// Attributes: x (number), y (number), width (number), height (number)
        /// </summary>
        internal const int TokenDrawFillRect = 34;

        /// <summary>
        /// Attributes:  x (number), y (number), width (number), height (number)
        /// </summary>
        internal const int TokenFillRect = 35;

        /// <summary>
        /// Attributes: x (number), y (number), width (number), height (number), leftInset (number), rightInset (number), topInset (number), bottomInset (number), scalingHint (number C), data (byte[])
        /// </summary>
        internal const int TokenDrawImage = 36;

        /// <summary>
        /// Attributes: points (tupel[])
        /// </summary>
        internal const int TokenDrawPolyline = 37;

        /// <summary>
        /// Attributes: points (tupel[])
        /// </summary>  
        internal const int TokenDrawPolygon = 38;

        /// <summary>
        /// Attributes: points (tupel[])
        /// </summary>  
        internal const int TokenFillPolygon = 39;

        /// <summary>
        /// Attributes: points (tupel[])
        /// </summary>  
        internal const int TokenDrawFillPolygon = 40;

        /// <summary>
        /// Attributes: x (number), y (number), width (number), height (number)
        /// </summary>  
        internal const int TokenDrawOval = 41;

        /// <summary>
        /// Attributes: x (number), y (number), width (number), height (number)
        /// </summary>  
        internal const int TokenFillOval = 42;

        /// <summary>
        /// Attributes: x (number), y (number), width (number), height (number), startAngle (number), endAngle (number)
        /// </summary>  
        internal const int TokenDrawArc = 43;

        /// <summary>
        /// Attributes: x (number), y (number), width (number), height (number), startAngle (number), endAngle (number)
        /// </summary>  
        internal const int TokenFillArc = 44;

        /// <summary>
        /// Attributes: 
        /// </summary>  
        internal const int TokenDrawLineElement = 45;

        /// <summary>
        /// Attributes: x (number), y (number), width (number), height (number), arcWidth (number), arcHeight (number)
        /// </summary>  
        internal const int TokenDrawRoundRect = 46;

        /// <summary>
        /// Attributes: x (number), y (number), width (number), height (number), arcWidth (number), arcHeight (number)
        /// </summary>  
        internal const int TokenFillRoundRect = 47;

        /// <summary>
        /// Attributes: x (number), y (number), width (number), height (number)
        /// </summary>  
        internal const int TokenFillRectSmooth = 48;

        /// <summary>
        /// Attributes: page(number), preContext(string), result(string), postContext(string), chunks (SearchChunk[])
        /// </summary>  
        public const int TokenSearchResult = 50;

        /// <summary>
        /// Attributes: lastPage(number), timestamp (8-byte 
        /// </summary>  
        public const int TokenSearchStatus = 51;

        /// <summary>
        /// Attributes: id(number)
        /// </summary>        
        internal const int TokenFontId = 52;

        /// <summary>
        /// Attributes: rev(number)
        /// </summary>        
        internal const int TokenFontRev = 53;

        /// <summary>
        /// Attributes: compress(boolean), data(byte[])
        /// </summary>        
        internal const int TokenFontData = 54;

        /// <summary>
        /// Attributes:
        /// </summary>        
        internal const int TokenImage = 78;

        /// <summary>
        /// Attributes: x (number), y (number)
        /// </summary>        
        internal const int TokenPoint = 79;

        /// <summary>
        /// Attributes: NumberOfPrompts (number)
        /// Sub elements: Prompt
        /// </summary>        
        internal const int TokenPrompts = 80;

        /// <summary>
        /// Attributes: Yes: 1 (number), Name (String), SubreportName (String), Text (String), Values (String[]), Descriptions (String[]), Type (number), discrete?1:0, range?1:0, multi?1:0, 
        ///             Editable?1:0 (number), OnlyDesc?1:0 (number), informix?1:0, EditMask (String), MinValue (string), MaxValue (string), CascadingParent (string), DisplayName (string)
        ///             No: 0 (number)
        /// </summary>        
        internal const int TokenPrompt = 81;

        /// <summary>
        /// Attributes: Amount of nodes (number)
        /// Sub elements: GroupTreeNode
        /// </summary>        
        internal const int TokenGroupTree = 90;

        /// <summary>
        /// Attributes: level (number), requestType (number), groupNumber (number), requestURL (String), groupNameValue (String), yFrom(number), yTo (number), pageFrom(number), pageTo (number)
        /// </summary>        
        internal const int TokenGroupTreeNode = 91;

        // Tokens fr Graphics2D

        /// <summary>
        /// Attributes: GraphicsID (number)
        /// </summary>        
        public const int TokenCreate = 100;

        /// <summary>
        /// Attributes: GraphicsID (number)
        /// </summary>
        public const int TokenDispose = 101; // = Chart und Bean finish

        /// <summary>
        /// Attributes: GraphicsID (number)
        /// </summary>
        public const int TokenChangeGraphics = 102;

        /// <summary>
        /// Attributes: Transform (transform)
        /// </summary>
        public const int TokenTransform = 103;

        /// <summary>
        /// Attributes: Transform (transform)
        /// </summary>
        public const int TokenSetTransform = 104;

        /// <summary>
        /// Attributes: Shape (shape)
        /// </summary>
        internal const int TokenSetClipShape = 105;

        /// <summary>
        /// Attributes: Shape (shape)
        /// </summary>
        internal const int TokenDrawShape = 106;

        /// <summary>
        /// Attributes: Shape (shape)
        /// </summary>
        internal const int TokenFillShape = 107;

        /// <summary>
        /// Attributes: width(float), cap(number), join(number), MiterLimit(float), dash(float[]), DashPhase(float)
        /// </summary>
        internal const int TokenSetStroke = 108;

        /// <summary>
        /// Attributes: rule(number), alpha(float)
        /// </summary>
        internal const int TokenSetComposite = 109;

        internal const int TokenDrawStringG2D = 110;

        /// <summary>
        /// Attributes: CacheTimeoutWasSuccessfullyReset(boolean)
        /// </summary>
        public const int TokenPingInfo = 120;

        /// <summary>
        /// Attributes:
        /// </summary>
        public const int TokenPageLimit = 121;

        internal const string ProtocolVersion = "2.1";
        internal const double ViewerProtocolVersion = 2.1;

        internal static readonly byte[] Signature = new byte[] { 0x1A, 0x58, 0x4D, 0x4C }; // 26, 88, 77, 76
    }
}